#ifndef NetLoadD_Config_H
#define NetLoadD_Config_H

#include <stdio.h>
#include <string.h>

#define DEF_Delay 5
#define DEF_Debug 1
#define DEF_Syslog 0
#define DEF_QuitOnError 1
#define DEF_Commentary 1
#define DEF_FileWrite 1

class TNetLoadD_Config
 {
 public:
 int Delay;
 int Debug;
 int Syslog;
 int QuitOnError;
 int Commentary;
 int FileWrite;
 const char* pYN(int x);
 void PrintConfig();
 TNetLoadD_Config(int iDelay= DEF_Delay, int iDebug= DEF_Debug, 
	int iSyslog= DEF_Syslog, int iQuitOnError= DEF_QuitOnError);
 int AutoConfig(char **List, int start, int finish);
 //TNetLoadD_Config(char **List, int start, int finish)
 // { AutoConfig(List, start, finish); }
 };

const char* TNetLoadD_Config::pYN(int x)
 {
 if (x==0) return "No";
 else return "Yes";
 }

void TNetLoadD_Config::PrintConfig()
 {
 printf("netloadd Current Configuration Settings:\n");
 printf("Delay\t\t\t%d seconds\n",Delay);
 printf("Debug Mode\t\t%s\n",pYN(Debug));
 printf("Syslog Output\t\t%s\n",pYN(Syslog));
 printf("Quit on Error\t\t%s\n",pYN(QuitOnError));
 printf("Commentary\t\t%s\n",pYN(Commentary));
 printf("File Write\t\t%s\n",pYN(FileWrite));
 }

TNetLoadD_Config::TNetLoadD_Config(int iDelay, int iDebug, int iSyslog,
	int iQuitOnError)
 {
 Delay=iDelay;
 Debug=iDebug;
 Syslog=iSyslog;
 QuitOnError=iQuitOnError;
 Commentary= DEF_Commentary;
 FileWrite= DEF_FileWrite;
 }

int TNetLoadD_Config::AutoConfig(char **List, int start, int finish)
 {
 if (start>finish) return 0;
 if (start<0) return 0;
 for (int a=start; a<=finish; a++)
  {
  if (List[a][0]=='d')
   {
   char del[12]={0,0,0,0,0,0,0,0,0,0,0,0};
   strncpy(del,List[a]+1,strlen(List[a])-1);
   Delay=atoi(del);
   if (Delay==0) Delay= DEF_Delay;
   }
  else
   {
   int Opt=0;
   if (List[a][0]=='+') Opt=1;
   else if (List[a][0]=='-') Opt=0;
   else return 0;
   char Option[32];
   for (int zx=0; zx<32; zx++) Option[zx]=0;
   strncpy(Option,List[a]+1,strlen(List[a])-1);
   int o=0;
   //printf("%d:%s\n",Opt,Option);
   if (strcmp(Option,"debug")==0) o='d';
   else if (strcmp(Option,"syslog")==0) o='s';
   else if (strcmp(Option,"quitonerror")==0) o='q';
   else if (strcmp(Option,"commentary")==0) o='c';
   else if (strcmp(Option,"file")==0) o='f';
   switch (o)
    {
    case 'd': Debug=Opt; break;
    case 's': Syslog=Opt; break;
    case 'q': QuitOnError=Opt; break;
    case 'c': Commentary=Opt; break;
    case 'f': FileWrite=Opt; break;
    default: return 0;
    }
   }
  }
 };

#endif
