// netloadd.h

#include <string.h>
#include <time.h>

#include "netloadd_config.h"

class TSample
 {
 public:
 unsigned long seconds;
 unsigned long transmitted;
 unsigned long received;
 TSample *Next;
 TSample(unsigned long sec, unsigned long trans, unsigned long rec,
		TSample *Nxt=0, TSample *Prev=0) 
  { Next=Nxt; seconds=sec; transmitted=trans; received=rec;
    if (Prev!=0) Prev->Next=this; }
 };


class TInterface
 {
 public:
 char Device[12];
 int MaxCount;
 int Count;
 void Clean();
 TSample *First;
 TSample *Last;
 unsigned long LastReceive;
 unsigned long LastTransmit;
 unsigned long LastSampled;
 unsigned long RxDiff;
 unsigned long TxDiff;
 unsigned long TimeDiff;
 unsigned long RxAverage;
 unsigned long TxAverage;
 int Sample();
 void PrintListStat(int);
 void AddSample(TSample *);
 TInterface(const char *Name="eth0", int MaxSamples=600);
 ~TInterface();
 int WriteToFile(const char *filename, int level=2, const char *mode="w");
 }; 

TInterface::TInterface(const char *Name, int MaxSamples)
 {
 strcpy(Device,Name);
 MaxCount=MaxSamples;
 First=0;
 Last=0;
 Count=0;
 LastReceive=0;
 LastTransmit=0;
 LastSampled=0;
 RxDiff=0;
 TxDiff=0;
 TimeDiff=0;
 RxAverage=0;
 TxAverage=0;
 };

int TInterface::Sample()
 {
 int DevFound=0;
 unsigned long rec=0;
 unsigned long trans=0;
 unsigned long sampled=0;
 //printf("%s\n",Device);
 FILE *fp=fopen("/proc/net/dev","r");
 if (fp<=0) return 0;
 char Line[1024];
 fgets(Line,1024,fp);
 fgets(Line,1024,fp);
 fgets(Line,1024,fp);
 while ((!feof(fp)) && (DevFound==0))
  {
  char TmpDev[12]={0,0,0,0,0,0,0,0,0,0,0,0};
  int a=0,b=0,count=0;
  while ( (b<2)&&(a<strlen(Line)) )
   {
   char s=Line[a++];
   if (s!=' ') b=1;
   if (s==':') b=2;
   if (b==1) TmpDev[count++]=s;
   }
  //printf("Device: %s\n",TmpDev);
  if (strcmp(TmpDev,Device)==0)
   {
   sampled=time(0);
   char bytes_rc[16];
   char bytes_tx[16];
   for (int z=0; z<16; z++)
    {
    bytes_rc[z]=0;
    bytes_tx[z]=0;
    }
   char s=Line[a++];
   while (s==' ')
    s=Line[a++];
   int rc_count=0;
   while (s!=' ')
    {
    bytes_rc[rc_count++]=s;
    s=Line[a++];
    }
   //printf("Received: %s bytes\n",bytes_rc);
   rec=atoll(bytes_rc);
   int skip_count=0,mode=0;
   while ( (a<strlen(Line))&&(skip_count<7))
    {
    s=Line[a++];
    if (s!=' ') mode=1;
    if ( (s==' ') && (mode==1) )
     {
     skip_count++;
     mode=0;
     }
    }
   s=Line[a++];
   while (s==' ') s=Line[a++];
   int tx_count=0;
   while (s!=' ')
    {
    bytes_tx[tx_count++]=s;
    s=Line[a++];
    }
   //printf("Transmitted %s bytes\n",bytes_tx);
   trans=atoll(bytes_tx);
   DevFound=1;
   }
  fgets(Line,1024,fp);
  }
 fclose(fp);
 //printf("Device [%s] sampled at %lu : %lu / %lu\n",Device,
 //	sampled,rec,trans);

 if (DevFound==0) return 0;
 if (LastSampled>0)
  {
  TimeDiff=sampled-LastSampled;
  TxDiff=trans-LastTransmit;
  RxDiff=rec-LastReceive;
  if (TimeDiff<=0) TimeDiff=1;
  RxAverage=( RxDiff / TimeDiff );
  TxAverage=( TxDiff / TimeDiff );
  }

 LastReceive=rec;
 LastTransmit=trans;
 LastSampled=sampled;
 
 TSample *nsample=new TSample(trans,rec,sampled);
 AddSample(nsample);

 return DevFound;
 }

void TInterface::AddSample(TSample *nsample)
 {
 if (First==0)
  {
  First=nsample;
  Last=nsample;
  Count++;
  return;
  }
 else if (Last==First)
  {
  First->Next=nsample;
  Last=nsample;
  Count++;
  return;
  }
 Last->Next=nsample;
 Last=nsample;
 Count++;
 if (Count>MaxCount)
  {
  TSample *t=First;
  First=First->Next;
  delete t;
  Count--;
  }
 }
 
void TInterface::Clean()
 {
 Count=0;
 Last=0;
 if (First==0) return;
 TSample *d=First;
 while (d->Next!=0)
  {
  TSample *s=d;
  d=d->Next;
  delete s;
  }
 delete d;
 First=0;
 }

TInterface::~TInterface()
 {
 Clean();
 }

void TInterface::PrintListStat(int full=0)
 {
 TSample *f=First;
 int acount=0;
 while (f!=0)
  {
  acount++;
  if (full>1)
   {
   printf("list[%d]: %lu secs\n",acount,f->seconds);
   }
  f=f->Next;
  }
 printf("ListStat: Count %d Actual %d\n",Count,acount);
 }

int TInterface::WriteToFile(const char *filename, int level, const char *mode)
 {
 FILE *fp=fopen(filename,mode);
 if (fp<=0) return 0;
 fprintf(fp,"netloadd status for device: %s\n",Device);
 fprintf(fp,"last rx %lu bytes, tx %lu bytes in %lu seconds\n",
	RxDiff, TxDiff, TimeDiff);
 fprintf(fp,"last average rx %lu bytes/sec, tx %lu bytes/sec over %lu seconds\n",
	RxAverage, TxAverage, TimeDiff);
 fclose(fp);
 }

