#include <stdio.h>
#include <stdlib.h>
#include <signal.h>
#include <time.h>
#include <unistd.h>

#include "BuildLog.h"
#define NetLoadD_Version_Major 1
#define NetLoadD_Version_Minor 0
#define NetLoadD_Version_Release 1
#define NetLoadD_Version_Build GOD_Build

char NLD_Version[64];

void NetLoadD_Version()
 {
 sprintf(NLD_Version,"%d.%d.%d/%d (%s)", NetLoadD_Version_Major,
	NetLoadD_Version_Minor, NetLoadD_Version_Release,
	NetLoadD_Version_Build, "Linux");
 }

void VersionInfo(int nl=0)
 {
 NetLoadD_Version();
 printf("netloadd %s Developmental Build",NLD_Version);
 if (nl>0) printf("\n");
 }

#include "netloadd.h"
TNetLoadD_Config *Config;

void CatchSignal(int sig);
void KillNetload(int);

TInterface *interface;

int main (int argnum, char **args)
 {
 Config=new TNetLoadD_Config();
 if (argnum<2)
  {
  printf("Usage %s [options] interface\n",args[0]);
  return 0;
  }
 else if (argnum>2)
  {
  if (Config->AutoConfig(args,1,argnum-2)==0)
   {
   printf("Error: incorrect/misunderstood command line parameters\n");
   return 0;
   }
  }
 if (Config->Commentary>0)
  {
  VersionInfo(0);
  printf(" Starting\n");
  }
 if (Config->Debug>0) Config->PrintConfig();
 interface=new TInterface(args[argnum-1],10);
 if (interface->Sample()==0)
  {
  printf("Error: device %s not found in /proc/net/dev\n",args[argnum-1]);
  return 0;
  }
 (void) signal( SIGINT, CatchSignal);
 (void) signal( SIGKILL, CatchSignal);
 while (1)
  {
  sleep(Config->Delay);
  if (interface->Sample()==0)
   {
   printf("Error fetching %s info from /proc/dev/net\n",
	interface->Device);
   if (Config->QuitOnError>0) KillNetload(0);
   }
  if (Config->Debug>0)
   {
  //interface->PrintListStat();
  printf("%s: Rx %lu bytes, Tx %lu bytes in %lu seconds\n",
	interface->Device,interface->RxDiff,interface->TxDiff,
	interface->TimeDiff);
  printf("%s: Total Rx %lu, Total Tx %lu\n",
	interface->Device,interface->LastReceive,interface->LastTransmit);
   }
  if (Config->FileWrite>0)
   {
   char filename[128];
   for (int z=0; z<128; z++) filename[z]=0;
   strcpy(filename,"/tmp/netloadd.");
   strcat(filename,interface->Device);
   interface->WriteToFile(filename,1);
   }
  }
 return 1;
 }

void CatchSignal(int sig)
 {
 printf("Caught Signal - Exixing\n");
 KillNetload(0);
 }

void KillNetload(int flag=1)
 {
 delete interface;
 exit(flag);
 }
